% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_linearEffects.R
\name{plot_linearEffects}
\alias{plot_linearEffects}
\title{Plot linear effects of a gam in an effect plot}
\usage{
plot_linearEffects(
  model,
  variables = NULL,
  return_plotData = FALSE,
  refCat = FALSE,
  ...
)
}
\arguments{
\item{model}{Model fitted with \code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{variables}{Optional character vector of variable names specifying which
effects should be plotted. The order of the vector corresponds to
the order in the effect plot. If the argument is not specified, all linear
effects are plotted according to the order of their appearance in the model
output.}

\item{return_plotData}{If TRUE, the dataset prepared for plotting is
returned. Defaults to FALSE.}

\item{refCat}{If TRUE, reference categories are added to the output for
categorical covariates. Defaults to FALSE.}

\item{...}{Additional arguments passed to
\code{\link{extract_summary_linearEffects}}.}
}
\value{
ggplot object
}
\description{
Create an effect plot of linear effects of a model fitted with
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effect.
}
\examples{
library(APCtools)
library(mgcv)

data(travel)
model <- gam(mainTrip_distance ~ te(age, period) + residence_region +
             household_size + s(household_income), data = travel)

plot_linearEffects(model)

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
