% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_APIS_2n.R
\name{APIS_2n}
\alias{APIS_2n}
\title{APIS for diploids}
\usage{
APIS_2n(
  offspring_genotype,
  sire_genotype,
  dam_genotype,
  method = "mendel",
  exclusion_threshold = NULL,
  error = 0.05,
  simulation_if_small = FALSE,
  number_offspring_simulated = max(0, 500 - nrow(offspring_genotype)),
  number_cores = 2,
  verbose = FALSE
)
}
\arguments{
\item{offspring_genotype}{matrix of the offspring genotypes}

\item{sire_genotype}{matrix of the sire genotypes}

\item{dam_genotype}{matrix of the offspring genotypes}

\item{method}{method : "mendel" i.e. likelihood or "exclusion" (default : "mendel"). Can also be "" to select the method a posteriori.}

\item{exclusion_threshold}{threshold for "exclusion" method (default : NULL). Override the error parameter if not NULL}

\item{error}{error accepted (default : 0.05)}

\item{simulation_if_small}{simulate individuals (TRUE or FALSE)}

\item{number_offspring_simulated}{number of offspring simulated (default : 500)}

\item{number_cores}{number of cores}

\item{verbose}{verbose}
}
\value{
list of 2 elements : a pedigree file and the log file
}
\description{
APIS for diploids
}
\examples{
data("APIS_offspring")
data("APIS_sire")
data("APIS_dam")

assignment <- APIS_2n(offspring_genotype = APIS_offspring[1:35,1:50],
                      sire_genotype = APIS_sire[ ,1:50],
                      dam_genotype = APIS_dam[ ,1:50],
                      simulation_if_small = FALSE)

}
