% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetFunctions.R
\name{checkMet}
\alias{checkMet}
\title{Check for met file errors.}
\usage{
checkMet(met, lmint = -8, umint = 32, lmaxt = 10, umaxt = 50)
}
\arguments{
\item{met}{Met file object.}

\item{lmint}{Lower bound on minimum temperature.}

\item{umint}{Upper bound on minimum temperature.}

\item{lmaxt}{Lower bound on maximum temperature.}

\item{umaxt}{Upper bound on maximum temperature.}
}
\description{
Checks for errors as described in
Wall, B.H. "TAMET: Computer program for processing meteorological data." CSIRO
Australia. Division of Tropical Crops and Pastures.Tropical Agronomy Technical Memorandum
(1977): No. 4, 13p.
}
\details{
Errors checked include:
\itemize{
  \item Temperature discontinuites.
  \item Temperatures that are too high orlow.
  \item Evaporation that is too high or low.
  \item Radiation that is too high or low.
  }
  
  Note that issues found may not stop APSIM from running
  but might indicate an issue with the weather data.
  Warnings may not be applicable for very hot or cold climates.

Expects input in metFile object. Use prepareMet or loadMet first.
}
\examples{
data(met)
checkMet(met)
}
