% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemi.R
\name{gemi}
\alias{gemi}
\title{Global Environmental Monitoring Index}
\usage{
gemi(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named gemi_'date of satellite image acqisition'.tif in the input folder
}
\description{
Global Environmental Monitoring Index (GEMI) is a vegetation based index designed to
reduce the effects of atmosperic effects.
}
\note{
1. GEMI = n (1 - 0.25n) - ((r_red - 0.125)/(1 - r_red))

where, n= (2 (r_nir^2 - r_red^2) + 1.5 r_nir + 0.5 r_red)/ (r_nir + r_red + 0.5)
and "r_" denotes TOA reflectance band.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
gemi (directory = path, crop = "y", ext2crop = shapefil)
}
\references{
\href{https://link.springer.com/article/10.1007/BF00031911}{Pinty, B. and M. M. Verstraete (1992) GEMI: a non-linear
index to monitor global vegetation from satellites, Vegetatio, 101 (1), 15-20.}
}
