% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{crop.bands}
\alias{crop.bands}
\title{Cropping of satellite image bands}
\usage{
crop.bands(directory = getwd(), crop = "n", ext2crop = "none",
  op_directory = directory, b1 = 1, b2 = 1, b3 = 1, b4 = 1, b5 = 1,
  b6 = 1, b7 = 1)
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}

\item{op_directory}{Specify the output directory (within double quotes). By default the input satellite image directory will be selected as the output directory.}

\item{b1}{By default Band1 will be cropped. To cancel cropping of this band assign value 0.}

\item{b2}{By default Band2 will be cropped. To cancel cropping of this band assign value 0.}

\item{b3}{By default Band3 will be cropped. To cancel cropping of this band assign value 0.}

\item{b4}{By default Band4 will be cropped. To cancel cropping of this band assign value 0.}

\item{b5}{By default Band5 will be cropped. To cancel cropping of this band assign value 0.}

\item{b6}{By default Band6 will be cropped. To cancel cropping of this band assign value 0.}

\item{b7}{By default Band7 will be cropped. To cancel cropping of this band assign value 0.}
}
\value{
Each bands selected will cropped and produce corresponding <bandname>_crop.tif format in the input directory.
}
\description{
Crop desired satellite image bands either using a shapefile or draw custom extent from a plot image while running the function.
}
\note{
1. FILENAMES OF ANY BAND FILES (*.TIF files) SHOULDN'T CHANGED.

2. Windows users should be careful while assigning directory. Use "/" to seperate folders not "\\".
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
# Assign 0 values to band names which are not required
crop.bands (path, crop = "f", ext2crop = shapefil, b3=0, b4=0, b5=0, b6 = 0, b7 = 0)
}
