% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pavi.R
\name{pavi}
\alias{pavi}
\title{Purified Adjusted Vegetation Index}
\usage{
pavi(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
Computed PAVI product
}
\description{
Purified Adjusted Vegetation Index (PAVI) is a vegetation based index.
}
\note{
1. PAVI= (r_nir^2 - r_red^2)/(r_nir^2 + r_red^2)

where, "r_" denotes TOA reflectance band.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
op <- pavi (directory = path, crop = "y", ext2crop = shapefil)
}
