% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_args.R
\name{check.args_}
\alias{check.args_}
\title{Check string arguments}
\usage{
check.args_(
  data_ = NULL,
  mandatory_ = FALSE,
  arg_ = NULL,
  class_ = NULL,
  class.action_ = NULL,
  message_ = message
)
}
\arguments{
\item{data_}{Data to be checked.}

\item{mandatory_}{If the argument is mandatory for the analysis.}

\item{arg_}{The string with the name of the function argument (e.g., \code{"gen"}).}

\item{class_}{The expected class of the variable in data.}

\item{class.action_}{The action to be taken if the variable has the wrong class.
Options are: \code{"message"}, \code{"warning"}, \code{"stop"}.}

\item{message_}{If \code{class.action_ == "message"}, write \code{message = "message"} to capture upstream message command.}

\item{rename_}{If the respective column should be renamed to the argument name (e.g., \code{"genotype"} to \code{"gen"}).}

\item{arg.update_}{If the value passed to the argument should be updated to the argument name (e.g., if \code{gen = "geno"}, then \code{gen == "gen"}).}
}
\description{
Check string arguments
}
\details{
This functions uses the \code{get} and \code{assign} which are need access to
objects that are one environment up on the hierarchy. The \code{envir} is set to
\code{parent.frame}. If the function is looking for something two or more environments up,
the arguments of \code{parent.frame} have to be changed.
}
\keyword{internal}
