% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_down.R
\name{step1_down}
\alias{step1_down}
\title{Step1 Down Model}
\usage{
step1_down(
  data,
  y,
  .time,
  K = NULL,
  C = NULL,
  validation = NULL,
  draw = 10000,
  parms = NULL,
  temp_pred_C = NULL,
  max_time_pred = NULL,
  confidence_interval = 0.95,
  by = 101,
  reparameterisation = FALSE,
  zero_order = FALSE
)
}
\arguments{
\item{data}{Dataframe containing accelerated stability data (required).}

\item{y}{Name of decreasing variable (e.g. concentration) contained within data
(required).}

\item{.time}{Time variable contained within data (required).}

\item{K}{Kelvin variable (numeric or column name) (optional).}

\item{C}{Celsius variable (numeric or column name) (optional).}

\item{validation}{Validation dummy variable (column name) (optional).}

\item{draw}{Number of simulations used to estimate confidence intervals.}

\item{parms}{Starting values for the parameters as a list - k1, k2, k3, and c0.}

\item{temp_pred_C}{Integer or numeric value to predict the response for a
given temperature (in Celsius).}

\item{max_time_pred}{Maximum time to predict the response variable.}

\item{confidence_interval}{Confidence level for the confidence and prediction intervals
around the predictions (default 0.95).}

\item{by}{Number of points (on the time scale) to smooth the statistical
intervals around the predictions.}

\item{reparameterisation}{Use alternative parameterisation of the one-step
model which aims to reduce correlation between k1 and k2.}

\item{zero_order}{Set kinetic order, k3, to zero (straight lines).}
}
\value{
An SB class object, a list including the following elements:
\itemize{
\item \emph{fit} - The non-linear fit.
\item \emph{data} - The data set.
\item \emph{prediction} - A data frame containing the predictions with the confidence and prediction intervals.
\item \emph{user_parameters} - List of users input parameters which is utilised by other
functions in the package.
}
}
\description{
Fit the one-step Šesták–Berggren kinetic model.
}
\details{
Fit the one-step Šesták–Berggren kinetic (non-linear) model using
accelerated stability data.
}
\examples{
#load antigenicity and potency data.
data(antigenicity)
data(potency)

#Basic use of the step1.down function with C column defined.
fit1 <- step1_down(data = antigenicity, y = "conc", .time = "time", C = "Celsius")

#Basic use of the step1.down function with K column defined.
fit2 <- step1_down(data = antigenicity, y = "conc", .time = "time", K = "K")

#When zero_order = FALSE, the output suggests using zero_order = TRUE for Potency dataset.
fit3 <- step1_down(data = potency, y = "Potency", .time = "Time",C = "Celsius",
  reparameterisation = FALSE, zero_order = TRUE)

#reparameterisation is TRUE.
fit4 <- step1_down(data = antigenicity, y = "conc", .time = "time",C = "Celsius",
  reparameterisation = TRUE)

}
