#' @title Accelerometry Data
#'
#' @description A dataset containing accelerometry data for a single subject in
#' 1-minute epochs, includes vector magnitude and other measurements
#'
#' \itemize{
#'   \item date. time and date of single measurement
#'   \item axis1. x-axis movement
#'   \item axis2. y-axis movement
#'   \item axis3. z-axis movement
#'   \item steps. steps taken by subject
#'   \item lux. amount of light present, measured in lux
#'   \item inclineOff.
#'   \item inclineStanding.
#'   \item inclineSitting.
#'   \item inclineLying.
#'   \item VM. vector magnitude, calculated from x-, y-, z-axis measurements
#' }
#'
#' @docType data
#' @keywords datasets
#' @name AccelData
#' @usage data("AccelData")
#' @format a data frame with 1351 rows and 11 variables
#'
NULL
