% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_plot_function.R
\name{line_plot}
\alias{line_plot}
\title{Graph: Line chart}
\usage{
line_plot(
  time,
  response,
  factor = NA,
  errorbar = "sd",
  ylab = "Response",
  xlab = "Time",
  legend.position = "right",
  theme = theme_classic()
)
}
\arguments{
\item{time}{Vector containing the x-axis values}

\item{response}{Vector containing the y-axis values}

\item{factor}{Vector containing a categorical factor}

\item{errorbar}{Error bars (sd or se)}

\item{ylab}{y axis title}

\item{xlab}{x axis title}

\item{legend.position}{Legend position}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}
}
\value{
Returns a line chart with error bars
}
\description{
Performs a descriptive line graph with standard deviation bars
}
\examples{
dose=rep(c(0,2,4,6,8,10),e=3,2)
resp=c(seq(1,18,1),seq(2,19,1))
fator=rep(c("A","B"),e=18)
line_plot(dose,resp,fator)
}
\seealso{
\link{radargraph}, \link{sk_graph}, \link{plot_TH}, \link{corgraph}, \link{spider_graph}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
