#' Dataset: Substrate data in the production of passion fruit seedlings
#'
#' @description An experiment was carried out in order
#' to evaluate the influence of the substrate on the
#' dry mass of aerial part and root in yellow sour
#' passion fruit. The experiment was conducted in a
#' randomized block design with four replications.
#' The treatments consisted of five substrates
#' (Vermiculite, MC Normal, Carolina Soil, Mc organic
#' and sand)
#'
#' @docType data
#'
#' @usage data(passiflora)
#'
#' @format data.frame containing data set
#'   \describe{
#'   \item{\code{trat}}{Categorical vector with substrate}
#'   \item{\code{bloco}}{Categorical vector with block}
#'   \item{\code{MSPA}}{Numeric vector with dry mass of aerial part}
#'   \item{\code{MSR}}{Numeric vector with dry mass of root}
#'   }
#' @keywords datasets
#' @seealso \link{cloro}, \link{enxofre}, \link{laranja}, \link{mirtilo}, \link{pomegranate}, \link{porco}, \link{sensorial}, \link{simulate1}, \link{simulate2}, \link{simulate3}, \link{tomate}, \link{weather}
#' @examples
#' data(passiflora)
"passiflora"
