% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjfatdbc_function.R
\name{conjfat2dbc}
\alias{conjfat2dbc}
\title{Analysis: Joint analysis of experiments in randomized block design in scheme factorial double}
\usage{
conjfat2dbc(
  f1,
  f2,
  block,
  experiment,
  response,
  transf = 1,
  model = 1,
  norm = "sw",
  homog = "bt",
  homog.value = 7,
  alpha.f = 0.05,
  alpha.t = 0.05
)
}
\arguments{
\item{f1}{Numeric or complex vector with factor 1 levels}

\item{f2}{Numeric or complex vector with factor 2 levels}

\item{block}{Numerical or complex vector with blocks}

\item{experiment}{Numeric or complex vector with locations or times}

\item{response}{Numerical vector containing the response of the experiment.}

\item{transf}{Applies data transformation (default is 1; for log consider 0)}

\item{model}{Define model of the analysis of variance}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{homog.value}{Reference value for homogeneity of experiments. By default, this ratio should not be greater than 7}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}
}
\value{
Returns the assumptions of the analysis of variance, the assumption of the joint analysis by means of a QMres ratio matrix and analysis of variance
}
\description{
Function of the AgroR package for joint analysis of experiments conducted in a randomized factorial double in block design with balanced data. The function generates the joint analysis through two models. Model 1: F-test of the effects of Factor 1, Factor 2 and F1 x F2 interaction are used in reference to the mean square of the interaction with the year. Model 2: F-test of the Factor 1, Factor 2 and F1 x F2 interaction effects are used in reference to the mean square of the residual.
}
\note{
The function is still limited to analysis of variance and assumptions only.
}
\examples{
library(AgroR)
ano=factor(rep(c(2018,2019,2020),e=48))
f1=rep(rep(c("A","B","C"),e=16),3)
f2=rep(rep(rep(c("a1","a2","a3","a4"),e=4),3),3)
resp=rnorm(48*3,10,1)
bloco=rep(c("b1","b2","b3","b4"),36)
dados=data.frame(ano,f1,f2,resp,bloco)
with(dados,conjfat2dbc(f1,f2,bloco,ano,resp, model=1))
}
\references{
Ferreira, P. V. Estatistica experimental aplicada a agronomia. Edufal, 2018.

Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Analysis}
\keyword{Double}
\keyword{Joint}
\keyword{factorial}
