% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_analysis.R
\name{LM}
\alias{LM}
\title{Analysis: Linear, quadratic, quadratic inverse, cubic and quartic regression}
\usage{
LM(
  trat,
  resp,
  ylab = "Dependent",
  error = "SE",
  xlab = "Independent",
  grau = NA,
  theme = theme_classic(),
  legend.position = "top",
  point = "all",
  scale = "none"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{grau}{degree of the polynomial (0.5, 1, 2, 3 or 4)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
Linear, quadratic, quadratic inverse, cubic and quartic regression.
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
LM(trat,resp, grau = 3)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{linear}
\keyword{regression}
