% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plot_similarity_heatmap}
\alias{plot_similarity_heatmap}
\title{A heatmap plot of the column identities between two multiple sequence alignments}
\usage{
plot_similarity_heatmap(x, scale = TRUE, display = TRUE)
}
\arguments{
\item{x}{an object of type "pairwise alignment comparison" (typically the summary file generated by compare_alignments)}

\item{scale}{scale data to proportion of characters that are not conserved gaps (default = TRUE)}

\item{display}{display this plot (default = TRUE)}
}
\description{
A heatmap plot of the column identities between two multiple sequence alignments
}
\note{
This function displays the similarity between each pairwise column comparison for the reference and comparison MSAs. Colour density is determined by the proportion of identical character matches between the columns, normalised to the number of characters that are not merely conserved gaps. This gives a representation of which columns are well agreed upon by the MSAs, and which columns are split by one MSA relative to the other.
}
\examples{
data(reference_alignment)
data(comparison_alignment)
PAC <- compare_alignments(reference_alignment,comparison_alignment)
plot_similarity_heatmap(PAC)

}

