% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullAS.R
\name{optimal}
\alias{optimal}
\title{Integer for the computation of an optimal alpha}
\usage{
optimal(n)
}
\arguments{
\item{n}{a non-negative integer, the maximal number of connected 
components of the alpha hull}
}
\value{
The value is the input integer \code{n} with a special class.
}
\description{
This function simply returns the given integer with a special 
  class; it is intended to be used in the \code{alpha} argument of the 
  \code{\link{setAlpha}} function to compute and set the optimal value of 
  alpha for which the alpha hull has no more than \code{n} connected 
  components.
}
\examples{
library(AlphaHull3D)
library(uniformly)
# sample some points in a torus ans some points in a sphere:
set.seed(666L)
pts_torus <- runif_in_torus(1000L, R = 3, r = 1)
pts_sphere <- runif_in_sphere(1000L, d = 3L, r = 1)
# shift the points in the sphere:
pts_sphere <- sweep(pts_sphere, 2L, c(0, 0, 2), FUN = "+")
# full alpha hull:
ahull <- fullAhull3d(rbind(pts_torus, pts_sphere))
# set optimal alpha for 2 connected components:
mesh <- setAlpha(ahull, alpha = optimal(2))
# plot:
library(rgl)
open3d(windowRect = c(50, 50, 562, 562))
shade3d(mesh, color = "yellow")
}
