% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{genParam}
\alias{genParam}
\title{Sumarize genetic parameters}
\usage{
genParam(pop, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
\describe{
\item{varA}{an nTrait by nTrait matrix of additive genetic variances}
\item{varD}{an nTrait by nTrait matrix of dominance genetic variances}
\item{varG}{an nTrait by nTrait matrix of total genetic variances}
\item{genicVarA}{an nTrait vector of additive genic variances}
\item{genicVarD}{an nTrait vector of dominance genic variances}
\item{genicVarG}{an nTrait vector of total genic variances}
\item{aveF}{an nTrait vector of the average inbreeding coefficient over all QTL}
\item{inbreeding}{an nTrait vector for the depression of mean due to inbreeding}
\item{mu}{an nTrait vector of trait means}
\item{bv}{a matrix of breeding values with dimensions nInd by nTraits}
\item{dd}{a matrix of dominance deviations with dimensions nInd by nTraits}
\item{gv_mu}{an nTrait vector of trait means for genotype with all zeros}
\item{gv_a}{a matrix of additive genetic values with dimensions nInd by nTraits}
\item{gv_d}{a matrix of dominance genetic values with dimensions nInd by nTraits}
}
}
\description{
Calculates genetic and genic additive and dominance variances 
for an object of \code{\link{Pop-class}}
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)
ans = genParam(pop, simParam=SP)

}
