% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch.R
\name{fetchSeries}
\alias{fetchSeries}
\title{Fetch time series data}
\usage{
fetchSeries(function_nm, ...)
}
\arguments{
\item{function_nm}{The function name. While case insensitive, this argument needs to be exactly as listed in the documentation. Examples include \code{time_series_daily}, \code{sma}, and \code{bbands}.}

\item{...}{Other arguments. If a required argument is missing then an error will be thrown. If an optional argument is missing then a warning will be thrown.}
}
\value{
A two element list: the first element is the \code{xts} object named \code{xts_object} and the second is the raw http response named \code{httr_response} (see \code{httr} package for details on this class)
}
\description{
This is the main function that pulls data directly from Alpha Vantage into a convenient \code{xts} object. This is a general function
that reflects exactly the documentation listed \href{https://www.alphavantage.co/documentation/}{online}.
}
\examples{
setAPIKey()
example_prices <- fetchSeries(function_nm = "time_series_daily", symbol = "msft")
example_sma <- fetchSeries(function_nm = "sma", symbol = "msft", interval = "daily",
                           time_period = 10, series_type = "open")
}
