% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardwareSprites.r
\docType{class}
\name{hardwareSprite-class}
\alias{hardwareSprite-class}
\alias{hardwareSprite}
\title{The hardwareSprite class}
\description{
An S4 class object that represent graphical objects known as
hardware sprites on the Commodore Amiga.
}
\details{
Amiga hardware supported sprites, which are graphical objects that
could be moved around the display and independently from each other.
Basic sprites were 16 pixels wide and any number of pixels high and
were composed of four colours, of which one is transparent.

More complex sprites could be formed by linking separate sprites
together. That way, sprites could become wider, or be composed of
more colours. Such extended sprites are currently not supported
by this package.

A well known example of hardware sprite on the Commodore Amiga is
the mouse pointer.

This object simply holds the basic information belonging to
hardware sprite. Use \code{\link{as.raster}} to convert it to
a raster which is a more useful graphical element in R.
}
\section{Slots}{

\describe{
\item{\code{VStart}}{The vertical starting position of a sprite.}

\item{\code{HStart}}{The horizontal starting position of a sprite.}

\item{\code{VStop}}{The vertical stopping position of a sprite. The
height of a sprite should be given by \code{VStart} - \code{VStop}.}

\item{\code{control.bits}}{8 \code{logical} values used for extending
sprites. The values are stored in this objects but extending
sprites is not (yet) supported.}

\item{\code{bitmap}}{Interleaved bitmap data containing information on
the pixel colour numbers of the sprite.}

\item{\code{colours}}{A vector of the 3 colours used for the sprite.}

\item{\code{end.of.data}}{Sprite data can be followed by another sprite. It is terminated
with two WORDS equalling zero (\code{raw(4)}). Repeated sprite data is currently not
supported.}
}}

\examples{
## This generates a sprite of a single line (16x1 pixels) with an empty bitmap:
new("hardwareSprite")

## This generates a sprite of a single line (16x1 pixels) where
## the bitmap contains some coloured pixels:
new("hardwareSprite", bitmap = as.raw(c(0x01,0x02,0x03,0x04)))

## This generates a sprite of 16x16 pixels:
new("hardwareSprite",
    VStop = 16,
    bitmap = as.raw(sample.int(255, 64, replace = TRUE)))
}
\references{
\url{http://amigadev.elowar.com/read/ADCD_2.1/Hardware_Manual_guide/node00AE.html}
}
\author{
Pepijn de Vries
}
