% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{read.AmigaBitmapFont}
\alias{read.AmigaBitmapFont}
\title{Read an AmigaBitmapFont class object from a file}
\usage{
read.AmigaBitmapFont(file, disk = NULL, ...)
}
\arguments{
\item{file}{The file name of a font subset is usually simply a numeric number
indicating the font height in pixels. Use \code{file} as a \code{character}
string representing that file location.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}

\item{...}{Arguments passed on to \code{\link{rawToAmigaBitmapFont}}.}
}
\value{
Returns an \code{\link{AmigaBitmapFont}} object read from the specified file.
}
\description{
Amiga Font Bitmaps of distinctive font heights are stored in separate
files, which in combination form a font collection or set. This
function can be used to read a specific bitmap from a set and returns
it as an \code{\link{AmigaBitmapFont}} class object.
}
\details{
Individual font bitmaps are stored in a font's subdirectory where
the file name is usually equal to the font height in pixels. This
function will read such a font bitmap file and return it as an
\code{\link{AmigaBitmapFont}} class object. It can also read such
files from \code{\link[adfExplorer]{amigaDisk-class}} objects,
but that requires the adfExplorer package to be installed.
}
\examples{
\dontrun{
data(font_example)

## Let's store the example font first:
write.AmigaBitmapFontSet(font_example, tempdir())

## Now read a specific subset from the font files:
font.sub <- read.AmigaBitmapFont(file.path(tempdir(), "AmigaFFH", "9"))

## The same can be done with a virtual Amiga disk. The following
## examples require the 'adfExplorer' package.
font.disk <- adfExplorer::blank.amigaDOSDisk("font.disk")
font.disk <- adfExplorer::dir.create.adf(font.disk, "FONTS")
font.disk <- write.AmigaBitmapFontSet(font_example, "DF0:FONTS", font.disk)
font.sub <- read.AmigaBitmapFont("DF0:FONTS/AmigaFFH/9", font.disk)
}
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{write.AmigaBitmapFont}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
\concept{io.operations}
