% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_configuration.r
\name{read.SysConfig}
\alias{read.SysConfig}
\title{Read an Amiga system-configuration file}
\usage{
read.SysConfig(file, disk = NULL)
}
\arguments{
\item{file}{The file name of a system-configuration file to be read.
Can also be a connection that allows reading binary data.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk()}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}
}
\value{
Returns an S3 \link{SysConfig} class object based on the file that is read.
}
\description{
Read a binary Amiga system-configuration file and return as \link{SysConfig} object.
}
\details{
Amiga OS 1.x stored system preferences in a binary system-configuration file. This
function returns the file in a comprehensive format (a \link{SysConfig} object).
}
\examples{
\dontrun{
## Put a simple SysConfig object into the tempdir:
write.SysConfig(simpleSysConfig(), file.path(tempdir(), "system-configuration"))

## Now read the same file:
sc <- read.SysConfig(file.path(tempdir(), "system-configuration"))

## and plot it
plot(sc)
}
}
\seealso{
Other SysConfig.operations: 
\code{\link{SysConfig}},
\code{\link{rawToSysConfig}()},
\code{\link{simpleSysConfig}()},
\code{\link{write.SysConfig}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{SysConfig.operations}
\concept{io.operations}
