% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_functions.R
\name{export_ATAC_maelstrom}
\alias{export_ATAC_maelstrom}
\title{export_seurat_Maelstrom}
\usage{
export_ATAC_maelstrom(
  seurat_object,
  output_dir,
  min_cells = 50,
  ATAC_peak_assay = "peaks",
  cluster_id = "seurat_clusters",
  select_top_rows = TRUE,
  n_top_rows = 1e+05
)
}
\arguments{
\item{seurat_object}{object}

\item{output_dir}{directory where the files are outputted}

\item{min_cells}{minimum of cells a cluster needs to be exported}

\item{ATAC_peak_assay}{assay of the seurat object containing the peaks and peakcounts}

\item{cluster_id}{ID used for finding clusters of cells}

\item{select_top_rows}{only output the top variable rows, or all rows if false}

\item{n_top_rows}{amount of variable rows to export}
}
\value{
None, outputs maelstrom peak counts table in the output directory
}
\description{
normalize and export the peak table of a seurat object based on clusters
}
\examples{
sce_small <- readRDS(system.file("extdata","sce_small.Rds",package = 'AnanseSeurat'))
config_scANANSE(sce_small, min_cells = 2, output_dir = tempdir())
}
