% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object.R
\name{andromeda}
\alias{andromeda}
\title{Create an Andromeda object}
\usage{
andromeda(...)
}
\arguments{
\item{...}{Named objects. See details for what objects are valid. If no objects are provided, an
empty Andromeda is returned.}
}
\value{
Returns an \code{\link{Andromeda}} object.
}
\description{
By default the \code{Andromeda} object is created in the systems temporary file location. You can override
this by specifying a folder using \code{options(andromedaTempFolder = "c:/andromedaTemp")}, where
\code{"c:/andromedaTemp"} is the folder to create the Andromeda objects in.
}
\details{
Valid objects are data frames, \code{Andromeda} tables, or any other \code{dplyr} table.
}
\examples{
andr <- andromeda(cars = cars, iris = iris)

names(andr)
# [1] 'cars' 'iris'

andr$cars \%>\% filter(speed > 10) \%>\% collect()
# # A tibble: 41 x 2 
# speed dist 
# <dbl> <dbl> 
# 1 11 17 
# ...

close(andr)

}
