% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntManAPI.R
\name{AM_mix_components_prior_negbin}
\alias{AM_mix_components_prior_negbin}
\title{Negative Binomial Prior.}
\usage{
AM_mix_components_prior_negbin(a_R = NULL, b_R = NULL, a_P = NULL,
  b_P = NULL, R = NULL, P = NULL, init_R = NULL, init_P = NULL)
}
\arguments{
\item{a_R}{The shape parameter \eqn{a}  of the \eqn{Gamma(a,b)} prior distribution for \eqn{r}.}

\item{b_R}{The  rate parameter \eqn{b} of the \eqn{Gamma(a,b)} prior distribution for \eqn{r}.}

\item{a_P}{The parameter\eqn{a}  of the \eqn{Beta(a,b)} prior distribution for \eqn{p}.}

\item{b_P}{The parameter \eqn{b}  of the \eqn{Beta(a,b)} prior distribution for \eqn{p}.}

\item{R}{It allows  to fix  \eqn{r} to a specific value.}

\item{P}{It allows  to fix  \eqn{p} to a specific value.}

\item{init_R}{The initial value of \eqn{r}, when specifying \code{a_R} and \code{b_R}.}

\item{init_P}{The inivial  value of \eqn{p}, when specifying \code{a_P} and \code{b_P}.}
}
\value{
A configuration list to be used as \code{mix_components_prior} argument for \code{\link{AM_mcmc_fit}}.
}
\description{
This generate a configuration object for a Shifted Negative Binomial prior on the number of mixture components such as
\deqn{q_M(m)=Pr(M=m) =\frac{\Gamma(r+m-1)}{(m-1)!\Gamma(r)} p^{m-1}(1-p)^r, \quad m=1,2,3,\ldots}
The hyper-parameters \eqn{p\in (0,1)}  (probability of success) and \eqn{r>0} (size) can either be fixed using \code{r} and \code{p}
or assigned appropriate prior distributions.
In the latter case, we assume \eqn{p \sim Beta(a_P,b_P)} and \eqn{r \sim  Gamma(a_R,b_R)}. In AntMAN we assume the following
parametrization of the Gamma density:
\deqn{p(x\mid a,b )= \frac{b^a x^{a-1}}{\Gamma(a)} \exp\{ -bx \}, \quad x>0  }
}
\details{
If no arguments are provided, the default is \eqn{r = 1 , a_P = 1, b_P = 1}.

Additionnaly, when init_R and init_P are no specified, there is default values :
\eqn{init_R = 1} and \eqn{init_P = 0.5}
}
\examples{

AM_mix_components_prior_negbin (R=1, P=1)
AM_mix_components_prior_negbin ()
}
\seealso{
\code{\link{AM_mcmc_fit}}
}
\keyword{prior}
