% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AM_prior_K_NegBin}
\alias{AM_prior_K_NegBin}
\title{This function compute the prior on the number of cluster, i.e. occupied component of the mixutre for a Finite Dirichlet process when the prior on the component-weigts of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormailized weights are distributed as Gamma(\eqn{\gamma},1) ) when the prior on the number of componet  is Negative Binomial with parameter \code{r>0} and \code{0<p<1}, with  mean is mu =1+ r*p/(1-p) TODO: CHECK THIS FORMULA!!!. See Section 9.1.1 of the Paper Argiento de Iorio 2019 for more details.}
\usage{
AM_prior_K_NegBin(n, gamma, r, p)
}
\arguments{
\item{n}{The sample size}

\item{gamma}{The \code{gamma} parameter of the Dirichlet}

\item{r}{The dispersion parameter \code{r} of Negative Binomial}

\item{p}{The probability of failure parameter \code{p} of Negative Binomial}
}
\value{
A vector of length n, reporting the values \code{V(n,k)} for \code{k=1,...,n}
}
\description{
There are no default values.
}
\examples{
n <- 50
gamma <- 1
r <- 0.1
p <- 0.91
gam_nb <- 0.2381641
prior_K_nb <-  AM_prior_K_NegBin(n,gam_nb,r,p)
plot(1:n,prior_K_nb, type = "n", bty = "l", xlab = "k", ylab = "P(K=k)")
lines(1:n,prior_K_nb,type="h",lwd=2)
}
\keyword{cluster}
\keyword{number}
\keyword{of}
\keyword{prior}
