% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{fractionation}
\alias{fractionation}
\title{Compute the mass fractionation correction}
\usage{
fractionation(fname, detector, MS = "ARGUS-VI", PH = FALSE)
}
\arguments{
\item{fname}{a .csv file with the air shot data}

\item{detector}{the name of the ion detector}

\item{MS}{the type of mass spectrometer}

\item{PH}{TRUE if the data were recorded in 'peak hopping' mode,
FALSE if recorded in multicollector mode.}
}
\value{
an object of class \code{\link{logratios}}
}
\description{
Compares the measured 40Ar/36Ar ratio of an air shot on a given
detector with the atmospheric ratio.
}
\examples{
data(Melbourne)
fd37file <- system.file("AirL2.csv",package="ArArRedux")
fd40file <- system.file("AirH1.csv",package="ArArRedux")
fract <- list(fractionation(fd37file,"L2",PH=TRUE),
              fractionation(fd40file,"H1",PH=FALSE))
if (isTRUE(all.equal(Melbourne$fract,fract))){
  print("We just re-created the fractionation correction for the Melbourne dataset")
}
}

