% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiSuccessionPlot.R
\name{MultiSuccessionPlot}
\alias{MultiSuccessionPlot}
\title{Successive Phases Density Plots (for phases in temporal order constraint)}
\usage{
MultiSuccessionPlot(
  data,
  position_minimum,
  position_maximum = position_minimum + 1,
  level = 0.95,
  title = "Characterisation of a succession of groups",
  colors = NULL,
  exportFile = NULL,
  exportFormat = "PNG"
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position_minimum}{Numeric vector containing the column number
corresponding to the minimum of the events included in each group.}

\item{position_maximum}{Numeric vector containing the column number
corresponding to the end of the groups set in the same order as
in \code{position_minimum}.}

\item{level}{Probability corresponding to the level of confidence.}

\item{title}{Title of the plot.}

\item{colors}{Vector of colors corresponding to each group of dates.}

\item{exportFile}{Name of the file to be saved.
If \code{NULL} then no plot is saved.}

\item{exportFormat}{Format of the export file, either "PNG"
or "SVG" (default).}
}
\value{
\code{NULL}, called for its side effects
}
\description{
This functions draws a plot of the densities of several successive phases
and adds several statistics (mean, CI, HPDR). The result is given in
calendar years (BC/AD).
}
\details{
Curves represent the density of the minimum (oldest dates) and the maximum
(youngest dates) of the dates included in each group. Curves of the same
color refer to the same phase. When there is only one curve of one color,
it means that there is only one event in the corresponding group and then
the minimum equals the maximum. Time range intervals are symbolised by
segments above the curves drawn using the same color as the one of the curves
of the associated group. Transition and gap range intervals are represented
by two-coloured segments using the colors of successive phases. If the gap
between the successive groups does not exist, a cross is drawn instead of a segment.
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  # List of the name of the groups
  names(Phases)
  # Stipulating position_end
  MultiSuccessionPlot(Phases, c(4, 2), c(5, 3),
                      title = "Succession of phase 1 and phase 2")
  # In this case, equivalent to
  MultiSuccessionPlot(Phases, c(4, 2),
                      title = "Succession of phase 1 and phase 2",
                      colors = c(3, 4))

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
