% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalStatistics.R
\name{MarginalStatistics}
\alias{MarginalStatistics}
\title{Marginal summary statistics}
\usage{
MarginalStatistics(a_chain, level = 0.95, roundingOfValue = 0)
}
\arguments{
\item{a_chain}{Numeric vector containing the output of the MCMC
algorithm for the parameter.}

\item{level}{Probability corresponding to the level of confidence
used for the credible interval and the highest posterior density region.}

\item{roundingOfValue}{Integer indicating the number of decimal places.}
}
\value{
A named matrix of values corresponding to all the following statistics:
\describe{
\item{title}{The title of the summary statistics.}
\item{mean}{The mean of the MCMC chain. Use of \code{mean()} function.}
\item{map }{The maximum a posteriori of the MCMC chain. Use of \code{hdr()} function.}
\item{sd}{The standard deviation of the MCMC chain. Use of \code{sd()} function.}
\item{Q1, median, Q3 }{The quantiles of the MCMC chain corresponding to 0.25, 0.50 and 0.75. Use of \code{quantile} function.}
\item{CI}{The credible interval corresponding to the desired level. Use of \code{CredibleInterval()} function.}
\item{HPDR}{The highest posterior density regions corresponding to the desired level. Use of \code{hdr()} function.}
}
}
\description{
Calculates summary statistics of the output of the MCMC algorithm for a one-parameter. Results are given in calendar years (BC/AD).
}
\details{
The \eqn{(100 * level)}\\% highest posterior density region is estimated using \code{hdr()} function from \pkg{hdrcde} package.
}
\examples{
  data(Events); attach(Events)
  MarginalStatistics(Event.1)
  MarginalStatistics(Event.2, level = 0.90)

}
\references{
Hyndman, R. J. (1996) Computing and graphing highest density regions. American Statistician, 50, 120-126.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
