% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempoPlot.R
\name{tempo_plot}
\alias{tempo_plot}
\title{Tempo plot}
\usage{
tempo_plot(
  data,
  position = 1:ncol(data),
  name = list("All"),
  level = 0.95,
  count = TRUE,
  Gauss = FALSE,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  legend_title = NULL,
  legend_position = "bottom",
  legend_labels = c("Bayes estimate", "Credible interval high",
    "Credible interval low"),
  x_label = "Calendar year",
  y_label = "Cumulative events",
  line_types = c("solid", "dotted", "dotted"),
  line_sizes = c(1.2, 0.8, 0.8),
  line_colors = c("black", "grey50", "grey50"),
  width = 7,
  height = 7,
  unit = "in",
  x_min = NULL,
  x_max = NULL,
  color_palette = NULL,
  file = NULL,
  x_scale = "calendar",
  elapsed_origin_position = NULL,
  columns = 1,
  new_window = TRUE,
  plot_result = TRUE
)
}
\arguments{
\item{data}{Data frame or \code{archaeophases_mcmc} object containing
the output of the MCMC algorithm.}

\item{position}{A list, each member of which is either a numeric vector
containing the positions of the columns corresponding to the MCMC chains
of interest, or a vector of column names. For convenience, a vector can
be substituted for the singleton list.}

\item{name}{A list, each member of which is a string that names the kind of
event in the corresponding element of \code{position}. For convenience, a
string can be substituted for the singleton list.}

\item{level}{Probability corresponding to the level of confidence.}

\item{count}{If \code{TRUE} the counting process is a number,
otherwise it is a probability.}

\item{Gauss}{If \code{TRUE}, the Gaussian approximation of the
credible interval is used.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{legend_title}{Title of the plot legend.}

\item{legend_position}{One of "top", "bottom" (default),
"left", "right".}

\item{legend_labels}{Vector of three strings to label legend entries.
The strings must be unique.  The first string labels the central tendency
and the second and third strings label the high and low spreads.}

\item{x_label}{Label of the x-axis.}

\item{y_label}{Label of the y-axis.}

\item{line_types}{Type of the lines drawn on the plot in the order
of \code{legend_labels}.}

\item{line_sizes}{Width of the lines drawn on the plot in the
order of \code{legend_labels}.}

\item{line_colors}{Color names for the lines drawn on the plot
in the order of \code{legend_labels}.  If \code{color_palette} is
\code{NULL}, then standard color names are expected, otherwise the
color names are from the supplied \code{color_palette}.}

\item{width}{Width of the plot in \code{unit}.}

\item{height}{Height of the plot in \code{unit}.}

\item{unit}{String recognized by the \code{ggsave()} function,
one of "in" (default), "cm", or "mm".}

\item{x_min}{Minimum value for x-axis.}

\item{x_max}{Maximum value for x-axis.}

\item{color_palette}{A palette that supplies the colors used in the plot.}

\item{file}{Name of the file that will be saved if specified.
If \code{NULL} no file is saved.}

\item{x_scale}{One of "calendar" for calendar years, "BP" for years before present, or "elapsed" for time elapsed from a specified origin.}

\item{elapsed_origin_position}{If \code{x.scale} is "elapsed", the position
of the column corresponding to the event from which elapsed time is
calculated.}

\item{columns}{Number of columns for facet.}

\item{new_window}{Whether or not the plot is drawn within a new window.}

\item{plot_result}{If \code{TRUE}, then draw a plot on the display,
else suppress drawing.}
}
\value{
An \code{archaeophases_plot} object with the data and metadata
needed to reproduce the plot.
}
\description{
A statistical graphic designed for the archaeological study of
rhythms of the long term that embodies a theory of archaeological
evidence for the occurrence of events
}
\details{
The tempo plot is one way to measure change over time: it estimates the
cumulative occurrence of archaeological events in a Bayesian calibration.
The tempo plot yields a graphic where the slope of the plot directly
reflects the pace of change: a period of rapid change yields a steep slope
and a period of slow change yields a gentle slope. When there is no change,
the plot is horizontal. When change is instantaneous, the plot is vertical.
}
\examples{
  data(Events);
  tempo_plot(Events[1:1000, ], c(2:5))
  tempo_plot(Events[1:1000, ], c(2:5), count = TRUE)

\dontrun{
# Read from connection
ox <- read_oxcal("http://tsdye.online/AP/ox.csv")
# Plot all the columns
tp <- tempo_plot(ox)
# Reproduce the tempo plot
plot(tp)
# View metadata
str(tp)
# Check that the MCMC data file hasn't changed
original_file(tp)

# Use a custom palette
library(khroma)
light <- colours("light")
tp <- tempo_plot(ox, color_palette = light(2),
line_colors = c("light blue", "pale grey", "pale grey"))
}

}
\references{
Dye, T.S. (2016) Long-term rhythms in the development of Hawaiian social stratification.
Journal of Archaeological Science, 71, 1--9
}
\seealso{
\code{\link{TempoPlot}}

\code{\link{new_archaeophases_plot}}
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
