% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MCMC-class}
\alias{MCMC-class}
\alias{.MCMC}
\title{MCMC}
\description{
An S4 class to represent the output of a MCMC algorithm.
}
\section{Slots}{

\describe{
\item{\code{labels}}{A \code{\link{character}} vector specifying the name of the events.}

\item{\code{depth}}{A \code{\link{numeric}} vector giving the sample depth.}

\item{\code{hash}}{A \code{\link{character}} string giving the 32-byte MD5 hash of the
original data file.}
}}

\note{
This class inherits from \code{\link{matrix}}.
}
\section{Subset}{

In the code snippets below, \code{x} is a \code{MCMC} object.
\describe{
\item{\code{x[[i]]}}{Extracts a single event (one chain) selected by subscript
\code{i}. \code{i} is a length-one \code{\link{numeric}} or \code{\link{character}} vector.}
}
}

\seealso{
Other classes: 
\code{\link{ActivityEvents-class}},
\code{\link{AgeDepthModel-class}},
\code{\link{CumulativeEvents-class}},
\code{\link{DurationsMCMC-class}},
\code{\link{EventsMCMC-class}},
\code{\link{OccurrenceEvents-class}},
\code{\link{PhasesMCMC-class}},
\code{\link{TimeRange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
