% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volendo.R
\name{volendo}
\alias{volendo}
\title{volendo}
\usage{
volendo(mesh, alpha_vol = 100, ncells = 1e+05)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{alpha_vol}{numeric: alpha shape for construction external concave hull}

\item{ncells}{numeric: approximative number of cell for 3D grid construction}
}
\value{
vol numeric: volume of the mesh expressed in cc
}
\description{
Calculate the volume of a mesh by using a voxel-based method
}
\examples{
\dontrun{
#load the human skull
library(rgl)
data(human_skull)
sapendo<-endomaker(human_skull,param1_endo = 1.0,vol=FALSE, num.cores=NULL)
volsap<-volendo(sapendo$endocast)
}
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
