% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endomaker.R
\name{endomaker}
\alias{endomaker}
\title{endomaker}
\usage{
endomaker(
  mesh = NULL,
  path_in = NULL,
  param1_endo = 1,
  npovs = 50,
  volume = TRUE,
  alpha_vol = 100,
  nVoxels = 1e+05,
  decmesh = 20000,
  alpha_ext = 30,
  ncells = 50000,
  npovs_calse = 50,
  param1_calse = 2,
  param1_ast = 1.3,
  decendo = 20000,
  scalendo = 0.5,
  alpha_end = 100,
  mpovdist = 10,
  plot = FALSE,
  colmesh = "orange",
  save = FALSE,
  outpath = tempdir(),
  num.cores = NULL
)
}
\arguments{
\item{mesh}{mesh3d: 3D model of the skull}

\item{path_in}{character: path of the skull where is stored}

\item{param1_endo}{numeric: parameter for spherical flipping}

\item{npovs}{numeric: number of Points of View used in the endocast construction}

\item{volume}{logical: if TRUE the calculation of the volume (expressed in cc) through concave is returned}

\item{alpha_vol}{numeric: alpha shape for volume calculation}

\item{nVoxels}{numeric: number of voxels for estimation endocranial volume}

\item{decmesh}{numeric: decmesh}

\item{alpha_ext}{numeric: alpha shape for construction external cranial mesh}

\item{ncells}{numeric: approximative number of cell for 3D grid construction}

\item{npovs_calse}{numeric: number of Points of View for construction of skull shell}

\item{param1_calse}{numeric: parameter for calse (construction shell)}

\item{param1_ast}{numeric: parameter for ast3d (construction row endocast)}

\item{decendo}{numeric: desired number of triangles (row endocast)}

\item{scalendo}{numeric: scale factor row endocast (for definition of POVs)}

\item{alpha_end}{numeric: alpha shape value for concave hull (row endocast)}

\item{mpovdist}{numeric: mean value between POVs and mesh}

\item{plot}{logical: if TRUE the endocast is plotted}

\item{colmesh}{character: color of the mesh to be plotted}

\item{save}{logical: if TRUE the mesh of the endocast is saved}

\item{outpath}{character: path where save the endocast}

\item{num.cores}{numeric: numbers of cores to be used in parallel elaboration}
}
\value{
endocast mesh3d: mesh of the endocast

volume numeric: volume of the endocast expressed in cc
}
\description{
Build endocast from a skull 3D mesh
}
\examples{
\dontrun{
library(rgl)
data(human_skull)
sapendo<-endomaker(human_skull,param1_endo = 1.0,decmesh = 20000, num.cores=NULL)
open3d()
wire3d(sapendo$endocast,col="violet")
ecv<-sapendo$volume
}
}
\references{
Profico, A., Buzi, C., Melchionna, M., Veneziano, A., & Raia, P. (2020). 
Endomaker, a new algorithm for fully automatic extraction of cranial endocasts and the calculation of their volumes. American Journal of Physical Anthropology.
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
