% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins.R
\name{makeBin}
\alias{makeBin}
\title{Make a bin}
\usage{
makeBin(
  x,
  y,
  bnds = list(x = range(x) - c(1, 0), y = range(y) - c(1, 0)),
  expn = length(x),
  n = length(x),
  depth = 0,
  stopped = FALSE
)
}
\arguments{
\item{x}{numeric vector of observations on the first variable}

\item{y}{numeric vector of observations on the second variable}

\item{bnds}{list of length two with named elements `x` and `y`
each a vector of length two giving respective bin boundaries}

\item{expn}{expected number of points in the bin, can be
non-integer}

\item{n}{observed count of points in the bin}

\item{depth}{number of splits from the initial bin to the bin}

\item{stopped}{logical; should the bin be split further?}
}
\value{
A list with named elements matching these arguments
}
\description{
Creating a new bin object
}
\details{
`makeBin` creates a bin list based on the arguments
provided to it. Should some be missing, basic defaults ensure
that the complete set of bin characteristics are created in
the resulting list representing the bin object.
}
\examples{
makeBin(x = 1:10, y = sample(1:10),
bnds = list(x = c(0,10), y = c(0, 10)), expn = 10, n = 10,
depth = 0, stopped = FALSE)
}
\author{
Chris Salahub
}
