% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{call_cognitive_endpoint}
\alias{call_cognitive_endpoint}
\alias{call_cognitive_endpoint.cognitive_endpoint}
\title{Call a Cognitive Service REST endpoint}
\usage{
call_cognitive_endpoint(endpoint, ...)

\method{call_cognitive_endpoint}{cognitive_endpoint}(endpoint, operation,
  options = list(), headers = list(), body = NULL, encode = NULL, ...,
  http_verb = c("GET", "POST", "PUT", "PATCH", "DELETE", "HEAD"),
  http_status_handler = c("stop", "warn", "message", "pass"))
}
\arguments{
\item{endpoint}{An object of class \code{cognitive_endpoint}.}

\item{...}{Further arguments passed to lower-level functions. For the default method, these are passed to \code{\link[httr:content]{httr::content}}; in particular, you can convert a structured JSON response into a data frame by specifying \code{simplifyDataFrame=TRUE}.}

\item{operation}{The operation to perform.}

\item{options}{Any query parameters that the operation takes.}

\item{headers}{Any optional HTTP headers to include in the REST call. Note that \code{call_cognitive_endpoint} will handle authentication details automatically, so don't include them here.}

\item{body}{The body of the HTTP request for the REST call.}

\item{encode}{The encoding (really content-type) for the body. See the \code{encode} argument for \code{\link[httr:POST]{httr::POST}}. The default value of NULL will use \code{raw} encoding if the body is a raw vector, and \code{json} encoding for anything else.}

\item{http_verb}{The HTTP verb for the REST call.}

\item{http_status_handler}{How to handle a failed REST call. \code{stop}, \code{warn} and \code{message} will call the corresponding \verb{*_for_status} handler in the httr package; \code{pass} will return the raw response object unchanged. The last one is mostly intended for debugging purposes.}
}
\value{
For a successful REST call, the contents of the response. This will usually be a list, obtained by translating the raw JSON body into R. If the call returns a non-success HTTP status code, based on the \code{http_status_handler} argument.
}
\description{
Call a Cognitive Service REST endpoint
}
\details{
This function does the low-level work of constructing a HTTP request and then calling the REST endpoint. It is meant to be used by other packages that provide higher-level views of the service functionality.
}
\examples{
\dontrun{

endp <- cognitive_endpoint("https://myvisionservice.api.cognitive.azure.com",
    service_type="Computervision", key="key")

# analyze an online image
img_link <- "https://news.microsoft.com/uploads/2014/09/billg1_print.jpg"
call_cognitive_endpoint(endp,
    operation="analyze",
    body=list(url=img_link),
    options=list(details="celebrities"),
    http_verb="POST")

# analyze an image on the local machine
img_raw <- readBin("image.jpg", "raw", file.info("image.jpg")$size)
call_cognitive_endpoint(endp,
    operation="analyze",
    body=img_raw,
    encode="raw",
    http_verb="POST")

}
}
\seealso{
\link{cognitive_endpoint}, \link{create_cognitive_service}, \link{get_cognitive_service}
}
