% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_container_instance.R
\docType{class}
\name{aci}
\alias{aci}
\alias{az_container_instance}
\title{Azure Container Instance class}
\description{
Class representing an Azure Container Instance (ACI) resource.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new ACI object.
\item \code{restart()}, \code{start()}: Start a stopped container. These methods are synonyms for each other.
\item \code{stop()}: Stop a container.
}
}

\section{Details}{

Initializing a new object of this class can either retrieve an existing ACI resource, or create a new resource on the host. Generally, the best way to initialize an object is via the \code{get_aci}, \code{create_aci} or \code{list_acis} methods of the \link{az_resource_group} class, which handle the details automatically.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

myaci <- rg$get_aci("mycontainer")

myaci$stop()
myaci$restart()

}
}
\seealso{
\link{acr}, \link{aks}

\href{https://docs.microsoft.com/en-us/azure/container-instances/}{ACI documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/container-instances/}{API reference}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker commandline reference}
}
