% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_graph.R
\name{call_graph_endpoint}
\alias{call_graph_endpoint}
\alias{call_graph_url}
\title{Call the Microsoft Graph REST API}
\usage{
call_graph_endpoint(token, operation, ..., options = list(),
  api_version = getOption("azure_graph_api_version"))

call_graph_url(token, url, ..., body = NULL, encode = "json",
  http_verb = c("GET", "DELETE", "PUT", "POST", "HEAD", "PATCH"),
  http_status_handler = c("stop", "warn", "message", "pass"),
  auto_refresh = TRUE)
}
\arguments{
\item{token}{An Azure OAuth token, of class \link{AzureToken}.}

\item{operation}{The operation to perform, which will form part of the URL path.}

\item{...}{Other arguments passed to lower-level code, ultimately to the appropriate functions in httr.}

\item{options}{A named list giving the URL query parameters.}

\item{api_version}{The API version to use, which will form part of the URL sent to the host.}

\item{url}{A complete URL to send to the host.}

\item{body}{The body of the request, for \code{PUT}/\code{POST}/\code{PATCH}.}

\item{encode}{The encoding (really content-type) for the request body. The default value "json" means to serialize a list body into a JSON object. If you pass an already-serialized JSON object as the body, set \code{encode} to "raw".}

\item{http_verb}{The HTTP verb as a string, one of \code{GET}, \code{PUT}, \code{POST}, \code{DELETE}, \code{HEAD} or \code{PATCH}.}

\item{http_status_handler}{How to handle in R the HTTP status code of a response. \code{"stop"}, \code{"warn"} or \code{"message"} will call the appropriate handlers in httr, while \code{"pass"} ignores the status code.}

\item{auto_refresh}{Whether to refresh/renew the OAuth token if it is no longer valid.}
}
\value{
If \code{http_status_handler} is one of \code{"stop"}, \code{"warn"} or \code{"message"}, the status code of the response is checked. If an error is not thrown, the parsed content of the response is returned with the status code attached as the "status" attribute.

If \code{http_status_handler} is \code{"pass"}, the entire response is returned without modification.
}
\description{
Call the Microsoft Graph REST API
}
\details{
These functions form the low-level interface between R and Microsoft Graph. \code{call_graph_endpoint} forms a URL from its arguments and passes it to \code{call_graph_url}.
}
\seealso{
\link[httr:GET]{httr::GET}, \link[httr:PUT]{httr::PUT}, \link[httr:POST]{httr::POST}, \link[httr:DELETE]{httr::DELETE}, \link[httr:stop_for_status]{httr::stop_for_status}, \link[httr:content]{httr::content}
}
