% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_rm.R
\docType{class}
\name{az_rm}
\alias{az_rm}
\title{Azure Resource Manager}
\format{
An R6 object of class \code{az_rm}.
}
\description{
Base class for interacting with Azure Resource Manager.
}
\section{Methods}{

\itemize{
\item \code{new(tenant, app, ...)}: Initialize a new ARM connection with the given credentials. See 'Authentication` for more details.
\item \code{list_subscriptions()}: Returns a list of objects, one for each subscription associated with this app ID.
\item \code{get_subscription(id)}: Returns an object representing a subscription.
\item \code{get_subscription_by_name(name)}: Returns the subscription with the given name (as opposed to a GUID).
\item \code{do_operation(...)}: Carry out an operation. See 'Operations' for more details.
}
}

\section{Authentication}{

The recommended way to authenticate with ARM is via the \link{get_azure_login} function, which creates a new instance of this class.

To authenticate with the \code{az_rm} class directly, provide the following arguments to the \code{new} method:
\itemize{
\item \code{tenant}: Your tenant ID. This can be a name ("myaadtenant"), a fully qualified domain name ("myaadtenant.onmicrosoft.com" or "mycompanyname.com"), or a GUID.
\item \code{app}: The client/app ID to use to authenticate with Azure Active Directory. The default is to login interactively using the Azure CLI cross-platform app, but it's recommended to supply your own app credentials if possible.
\item \code{password}: if \code{auth_type == "client_credentials"}, the app secret; if \code{auth_type == "resource_owner"}, your account password.
\item \code{username}: if \code{auth_type == "resource_owner"}, your username.
\item \code{certificate}: If `auth_type == "client_credentials", a certificate to authenticate with. This is a more secure alternative to using an app secret.
\item \code{auth_type}: The OAuth authentication method to use, one of "client_credentials", "authorization_code", "device_code" or "resource_owner". See \link{get_azure_token} for how the default method is chosen, along with some caveats.
\item \code{version}: The Azure Active Directory version to use for authenticating.
\item \code{host}: your ARM host. Defaults to \verb{https://management.azure.com/}. Change this if you are using a government or private cloud.
\item \code{aad_host}: Azure Active Directory host for authentication. Defaults to \verb{https://login.microsoftonline.com/}. Change this if you are using a government or private cloud.
\item \code{...}: Further arguments to pass to \code{get_azure_token}.
\item \code{scopes}: The Azure Service Management scopes (permissions) to obtain for this login. Only for \code{version=2}.
\item \code{token}: Optionally, an OAuth 2.0 token, of class \link{AzureToken}. This allows you to reuse the authentication details for an existing session. If supplied, all other arguments will be ignored.
}
}

\section{Operations}{

The \code{do_operation()} method allows you to carry out arbitrary operations on the Resource Manager endpoint. It takes the following arguments:
\itemize{
\item \code{op}: The operation in question, which will be appended to the URL path of the request.
\item \code{options}: A named list giving the URL query parameters.
\item \code{...}: Other named arguments passed to \link{call_azure_rm}, and then to the appropriate call in httr. In particular, use \code{body} to supply the body of a PUT, POST or PATCH request, and \code{api_version} to set the API version.
\item \code{http_verb}: The HTTP verb as a string, one of \code{GET}, \code{PUT}, \code{POST}, \code{DELETE}, \code{HEAD} or \code{PATCH}.
}

Consult the Azure documentation for what operations are supported.
}

\examples{
\dontrun{

# start a new Resource Manager session
az <- az_rm$new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")

# authenticate with credentials in a file
az <- az_rm$new(config_file="creds.json")

# authenticate with device code
az <- az_rm$new(tenant="myaadtenant.onmicrosoft.com", app="app_id", auth_type="device_code")

# retrieve a list of subscription objects
az$list_subscriptions()

# a specific subscription
az$get_subscription("subscription_id")

}
}
\seealso{
\link{create_azure_login}, \link{get_azure_login}

\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-overview}{Azure Resource Manager overview},
\href{https://docs.microsoft.com/en-us/rest/api/resources/}{REST API reference}
}
