% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{list_vm_sizes}
\alias{list_vm_sizes}
\title{List available VM sizes}
\description{
Method for the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} and \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'az_subscription'
list_vm_sizes(location, name_only = FALSE)

## R6 method for class 'az_resource_group'
list_vm_sizes(name_only = FALSE)
}
}

\section{Arguments}{

\itemize{
\item \code{location}: For the subscription class method, the location/region for which to obtain available VM sizes.
\item \code{name_only}: Whether to return only a vector of names, or all information on each VM size.
}
}

\section{Value}{

If \code{name_only} is TRUE, a character vector of names, suitable for passing to \code{create_vm}. If FALSE, a data frame containing the following information for each VM size: the name, number of cores, OS disk size, resource disk size, memory, and maximum data disks.
}

\examples{
\dontrun{

sub <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")

sub$list_vm_sizes("australiaeast")

# same output as above
rg <- sub$create_resource_group("rgname", location="australiaeast")
rg$list_vm_sizes()

}
}
\seealso{
\link{create_vm}
}
