% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nic_config.R
\name{nic_config}
\alias{nic_config}
\alias{nic_ip_config}
\title{Network interface configuration}
\usage{
nic_config(nic_ip = list(nic_ip_config()), ...)

nic_ip_config(name = "ipconfig", private_alloc = "dynamic",
  subnet = "[variables('subnetId')]",
  public_address = "[variables('ipId')]", ...)
}
\arguments{
\item{nic_ip}{For \code{nic_config}, a list of IP configuration objects, each obtained via a call to \code{nic_ip_config}.}

\item{...}{Other named arguments that will be treated as resource properties.}

\item{name}{For \code{nic_ip_config}, the name of the IP configuration.}

\item{private_alloc}{For \code{nic_ip_config}, the allocation method for a private IP address. Can be "dynamic" or "static".}

\item{subnet}{For \code{nic_ip_config}, the subnet to associate with this private IP address.}

\item{public_address}{For \code{nic_ip_config}, the public IP address. Defaults to the public IP address created or used as part of this VM deployment. Ignored if the deployment does not include a public address.}
}
\description{
Network interface configuration
}
\examples{
nic_config()
}
\seealso{
\link{create_vm}, \link{vm_config}
}
