% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{AIC.angmcmc}
\alias{AIC.angmcmc}
\alias{BIC.angmcmc}
\title{AIC and BIC for angmcmc objects}
\usage{
\method{AIC}{angmcmc}(object, burnin = 1/3, thin = 1, ...)

\method{BIC}{angmcmc}(object, burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{object}{an angmcmc object.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{optionally more fitted model objects.}
}
\value{
AIC computes the AIC and BIC computes BIC for \code{angmcmc} objects.
}
\description{
AIC and BIC for angmcmc objects
}
\details{
Let \eqn{\hat{L}} be the maximum value of the likelihood function for the model, \eqn{m} be the number of
estimated parameters in the model and \eqn{n} be the number of data points. Then AIC and BIC are defined as
\eqn{AIC = -2 \log \hat{L} + 2m} and \eqn{BIC = -2 \log \hat{L} + m \log(n)}.

\eqn{\hat{L}} is estimated by the sample maximum obtained from the MCMC realizations.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
AIC(fit.vmsin.20)
BIC(fit.vmsin.20)

}

