% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{logLik.angmcmc}
\alias{logLik.angmcmc}
\title{Extract Log-Likelihood from angmcmc objects}
\usage{
\method{logLik}{angmcmc}(object, method = 1, fn, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{method}{interger specifying method of estimating the log likelihood. Must be 1 or 2. Defaults to 1. See details.}

\item{fn}{function to evaluate on the iteration-wise log-likelihood values obtained during MCMC run if \code{method = 1}; or,
if \code{method = 2}, function to evaluate on the MCMC samples for parameter estimation (passed to \link{pointest}).
Defaults to \code{max} if \code{method = 1} and \code{mean} if \code{method = 2}.}

\item{...}{additional arguments to be passed to the function.}
}
\value{
Returns an object of class \link{logLik}. This is a number (the estimated log likelihood) with attributes "df"
(degrees of freedom) and "nobs" (number of observations).
}
\description{
Extract Log-Likelihood from angmcmc objects
}
\details{
There are two ways to estimate the log likelihood from the model. If \code{method = 1},
then log likelihood is estimated by applying \code{fn} (defaults to max, if method = 1)
direclty on the iteration-wise log likelihood values from the MCMC.
On the other hand, if \code{method == 2}, then  parameter estimates
are first computed using \code{pointest} with \code{fn}
(defaults to "MODE", if \code{method == 2}) applied on the MCMC samples,
and then then log likelihood is evaluated at the parameter estimates.


The degrees of the likelihood function is the total number of free parameters estimated in the mixture models,
which is equal to \eqn{6K - 1} for bivariate models (vmsin, vmcos and wnorm2), or \eqn{3K - 1} for univariate
models (vm and wnorm), where \eqn{K} denotes the number of components in the mixture model.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
logLik(fit.vmsin.20)
}
