% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_priors.R
\name{tr.poisson}
\alias{tr.poisson}
\alias{tr.Poisson}
\title{Truncated Poisson Prior Distribution for Models}
\usage{
tr.poisson(lambda, trunc)
}
\arguments{
\item{lambda}{parameter in the Poisson distribution representing expected
model size with infinite predictors}

\item{trunc}{parameter that determines truncation in the distribution i.e.
P(M; lambda, trunc) = 0 if M > trunc}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the prior distribution on models for BAS
using a truncated Poisson Distribution on the Model Size
}
\details{
The Poisson prior distribution on model size is obtained by assigning each
variable inclusion indicator independent Bernoulli distributions with
probability w, and then taking a limit as p goes to infinity and w goes to
zero, such that p*w converges to lambda.  The Truncated version assigns zero
probability to all models of size M > trunc.
}
\examples{
tr.poisson(10, 50)
}
\seealso{
\code{\link{bas.lm}}, \code{\link{Bernoulli}},\code{\link{uniform}}

Other priors modelpriors: \code{\link{Bernoulli.heredity}},
  \code{\link{Bernoulli}}, \code{\link{beta.binomial}},
  \code{\link{tr.beta.binomial}},
  \code{\link{tr.power.prior}}, \code{\link{uniform}}
}
\author{
Merlise Clyde
}
\concept{priors modelpriors}
