% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol.R
\name{sobol}
\alias{sobol}
\title{BASS Sensitivity Analysis}
\usage{
sobol(bassMod, mcmc.use = NULL, func.var = NULL, xx.func.var = NULL,
  verbose = TRUE)
}
\arguments{
\item{bassMod}{a fitted model output from the \code{bass} function.}

\item{mcmc.use}{an integer vector indexing which MCMC iterations to use for sensitivity analysis.}

\item{func.var}{an integer indicating which functional variable to make sensitivity indices a function of.  Disregard if \code{bassMod} is non-functional or if scalar sensitivity indices are desired.}

\item{xx.func.var}{grid for functional variable specified by \code{func.var}.  Disregard if \code{func.var} is not specified.  If \code{func.var} is specified and \code{xx.func.var} not specified, the grid used to fit \code{bass} will be used.}

\item{verbose}{logical; should progress be displayed?}
}
\value{
If non-functional (\code{func.var = NULL}), a list with two elements:
 \item{S}{a data frame of sensitivity indices with number of rows matching the length of \code{mcmc.use}.  The columns are named with a particular main effect or interaction.  The values are the proportion of variance in the model that is due to each main effect or interaction.}
 \item{T}{a data frame of total sensitivity indices with number of rows matching the length of \code{mcmc.use}.  The columns are named with a particular variable.}
 Otherwise, a list with four elements:
 \item{S}{an array with first dimension corresponding to MCMC samples (same length as \code{mcmc.use}), second dimension corresponding to different main effects and interactions (labeled in \code{names.ind}), and third dimension corresponding to the grid used for the functional variable.  The elements of the array are sensitivity indices.}
 \item{S.var}{same as \code{S}, but scaled in terms of total variance rather than percent of variance.}
 \item{names.ind}{a vector of names of the main effects and interactions used.}
 \item{xx}{the grid used for the functional variable.}
}
\description{
Decomposes the variance of the BASS model into variance due to main effects, two way interactions, and so on, similar to the ANOVA decomposition for linear models.  Uses the Sobol' decomposition, which can be done analytically for MARS models.
}
\details{
Performs analytical Sobol' decomposition for each MCMC iteration in mcmc.use (each corresponds to a MARS model), yeilding a posterior distribution of sensitivity indices.  Can obtain Sobol' indices as a function of one functional variable.
}
\examples{
# See examples in bass documentation.

}
\seealso{
\link{bass} for model fitting and \link{predict.bass} for prediction.
}
\keyword{Sobol}
\keyword{decomposition}

