% Generated by roxygen2 (4.0.1): do not edit by hand
\name{slope}
\alias{slope}
\title{Slope of accumulation curves.}
\usage{
slope(accum)
}
\arguments{
\item{accum}{A matrix resulting from the alpha.accum or beta.accum functions (samples x diversity values).}
}
\value{
A matrix of samples x slope values.
}
\description{
This is similar to the first derivative of the curves at each of its points.
}
\details{
The slope of an accumulation curve, of either observed or estimated diversity, allows verifying if the asymptote has been reached (Cardoso et al. 2011).
This is an indication of either the completeness of the inventory (low final slopes of the observed curve indicate high completeness) or reliability of the estimators (stability of the slope around a value of 0 along the curve indicates reliability).
}
\examples{
comm1 <- matrix(c(2,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,0,2,2), nrow = 4, ncol = 5, byrow = TRUE)
comm2 <- matrix(c(1,1,0,0,0,0,2,1,0,0,0,0,2,1,0,0,0,0,2,1), nrow = 4, ncol = 5, byrow = TRUE)
tree <- hclust(dist(c(1:5), method="euclidean"), method="average")
acc.alpha = alpha.accum(comm1)
slope(acc.alpha)
acc.beta = beta.accum(comm1, comm2, tree)
slope(acc.beta)
}
\references{
Cardoso, P., Pekar, S., Jocque, R. & Coddington, J.A. (2011) Global patterns of guild composition and functional diversity of spiders. PLoS One, 6, e21710.
}

