% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hyper.quality}
\alias{hyper.quality}
\title{Quality of hyperspace.}
\usage{
hyper.quality(distance, hyper)
}
\arguments{
\item{distance}{A dist matrix representing the initial distances between species.}

\item{hyper}{A matrix with trait data from function hyper.build.}
}
\value{
A single value of quality.
}
\description{
Assess the quality of a functional hyperspace.
}
\details{
The algorithm calculates the inverse of the squared deviation between initial and euclidean distances (Maire et al. 2015) after standardization of all values between 0 and 1 for simplicity of interpretation. A value of 1 corresponds to maximum quality of the functional representation. A value of 0 corresponds to the expected value for an hyperspace where all distances between species are 1.
}
\examples{
trait = data.frame(body = c(1,2,3,4,4), beak = c(1,1,1,1,2))
distance = gower(trait)

hyper = hyper.build(trait, axes = 2)
hyper.quality(distance, hyper)

hyper = hyper.build(trait, axes = 0)
hyper.quality(distance, hyper)
}
\references{
Maire et al. (2015) How many dimensions are needed to accurately assess functional diversity? A pragmatic approach for assessing the quality of functional spaces. Global Ecology and Biogeography, 24: 728:740.
}
