% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table_results.R
\name{get_table_results}
\alias{get_table_results}
\title{League cross table}
\usage{
get_table_results(df, competition, season)
}
\arguments{
\item{df}{Data frame with the games and the players info.}

\item{competition}{Competition.}

\item{season}{Season.}
}
\value{
List with these two elements:
\itemize{
\item plot_teams Graphical device with the cross table.
\item wins_teams Vector with the team wins.
}
}
\description{
The league results are represented with a cross table.
}
\examples{
\dontrun{
df <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718)
df$Compet <- "ACB"

gg <- get_table_results(df, "ACB", "2017-2018")

gg$wins_teams
gg$plot_teams
}

}
\author{
Guillermo Vinue
}
