% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rDAGWishart.R
\name{rDAGWishart}
\alias{rDAGWishart}
\title{Random samples from a compatible DAG-Wishart distribution}
\usage{
rDAGWishart(n, DAG, a, U)
}
\arguments{
\item{n}{number of samples}

\item{DAG}{\eqn{(q, q)} adjacency matrix of the DAG}

\item{a}{common shape hyperparameter of the compatible DAG-Wishart, \eqn{a > q - 1}}

\item{U}{position hyperparameter of the compatible DAG-Wishart, a \eqn{(q, q)} s.p.d. matrix}
}
\value{
A list of two elements: a \eqn{qxqxn} array collecting \eqn{n} sampled matrices \eqn{L} and a \eqn{qxqxn} array collecting \eqn{n} sampled matrices \eqn{D}
}
\description{
This function implements a direct sampling from a compatible DAG-Wishart distribution with parameters \code{a} and \code{U}.
}
\details{
Assume the joint distribution of random variables \eqn{X_1, \dots, X_q} is zero-mean Gaussian with covariance matrix Markov w.r.t. a Directed Acyclic Graph (DAG).
The allied Structural Equation Model (SEM) representation of a Gaussian DAG-model allows to express the covariance matrix as a function of the (Cholesky) parameters \eqn{(D,L)},
collecting the regression coefficients and conditional variances of the SEM.

The DAG-Wishart distribution (Cao et. al, 2019) with shape hyperparameter \eqn{a = (a_1, ..., a_q)} and position hyperparameter \eqn{U} (a s.p.d. \eqn{(q,q)} matrix) provides a conjugate prior for parameters \eqn{(D,L)}.
In addition, to guarantee compatibility among Markov equivalent DAGs (same marginal likelihood), the default choice (here implemented) \eqn{a_j = a + |pa(j)| - q + 1} \eqn{(a > q - 1)}, with \eqn{|pa(j)|} the number of parents of node \eqn{j} in the DAG,
was introduced by Peluso and Consonni (2020).
}
\examples{
# Randomly generate a DAG on q = 8 nodes with probability of edge inclusion w = 0.2
q = 8
w = 0.2
set.seed(123)
DAG = rDAG(q = q, w = w)
# Draw from a compatible DAG-Wishart distribution with parameters a = q and U = diag(1,q)
outDL = rDAGWishart(n = 5, DAG = DAG, a = q, U = diag(1, q))
outDL
}
\references{
F. Castelletti and A. Mascaro (2021). Structural learning and estimation of joint causal effects among network-dependent variables. \emph{Statistical Methods and Applications}, Advance publication.

X. Cao, K. Khare and M. Ghosh (2019). Posterior graph selection and estimation consistency for high-dimensional Bayesian DAG models. \emph{The Annals of Statistics} 47 319-348.

S. Peluso and G. Consonni (2020). Compatible priors for model selection of high-dimensional Gaussian DAGs. \emph{Electronic Journal of Statistics} 14(2) 4110 - 4132.
}
\author{
Federico Castelletti and Alessandro Mascaro
}
