% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour2.R
\name{contour2.bcea}
\alias{contour2.bcea}
\alias{contour2}
\title{Specialised CE-plane Contour Plot}
\usage{
\method{contour2}{bcea}(
  he,
  wtp = 25000,
  xlim = NULL,
  ylim = NULL,
  comparison = NULL,
  graph_type = c("base", "ggplot2"),
  ...
)

contour2(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{wtp}{The selected value of the willingness-to-pay. Default is
\code{25000}.}

\item{xlim}{Limits on the x-axis (default=\code{NULL}, so that R will select
appropriate limits).}

\item{ylim}{Limits on the y-axis (default=\code{NULL}, so that R will select
appropriate limits).}

\item{comparison}{The comparison being plotted. Default to \code{NULL}
chooses the first comparison if \code{graph_type="base"}. If
\code{graph_type="ggplot2"} the default value will choose all the possible
comparisons. Any subset of the possible comparisons can be selected (e.g.,
\code{comparison=c(1,3)}).}

\item{graph_type}{A string used to select the graphical engine to use for
plotting. Should (partial-)match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}.}

\item{...}{Arguments to be passed to \code{\link{ceplane.plot}}. See the
relative manual page for more details.}
}
\value{
\item{contour}{ A ggplot item containing the requested plot.
Returned only if \code{graph_type="ggplot2"}. } Plots the cost-effectiveness
plane with a scatterplot of all the simulated values from the (posterior)
bivariate distribution of (\eqn{\Delta_e, \Delta_c}), the differentials of
effectiveness and costs; superimposes a contour of the distribution and
prints the value of the ICER, together with the sustainability area.
}
\description{
Produces a scatterplot of the cost-effectiveness plane, with a contour-plot
of the bivariate density of the differentials of cost (y-axis) and
effectiveness (x-axis).  Also adds the sustainability area (i.e. below the
selected value of the willingness-to-pay threshold).
}
\examples{
## create the bcea object m for the smoking cessation example
data(Smoking)
m <- bcea(e, c, ref = 4, interventions = treats, Kmax = 500)

## produce the plot
contour2(m,
         wtp = 200,
         graph_type = "base")

\donttest{
## or use ggplot2 to plot multiple comparisons
contour2(m,
         wtp = 200,
         ICER_size = 2,
         graph_type = "ggplot2")
}

}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity
Analysis in Health Economics. Statistical Methods in Medical Research
doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{ceplane.plot}},
         \code{\link{contour}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{"Bayesian}
\keyword{"Health}
\keyword{economic}
\keyword{evaluation"}
\keyword{model"}
