% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Size.Block.R
\name{Size.Block}
\alias{Size.Block}
\title{Sample size calculator for randomized complete block design}
\usage{
Size.Block(factor,factor.lev,order,delta_type,delta,alpha,beta)
}
\arguments{
\item{factor}{the number of factor}

\item{factor.lev}{factor levels}

\item{order}{building the model with main or including the interaction effects ;
1 : only main effects(default) , 2 : both main and two-way interaction effects}

\item{delta_type}{type of standardized effect size ; 1 : standard deviation type(default), 2 : range of effect type}

\item{delta}{lists of effects size; The first and the second column is effect size of main and two-way interaction effects, respectively. The third column is standard devitaion of noise.}

\item{alpha}{Type I error ; 0.05 (default)}

\item{beta}{Type II error ; 0.20 (default)}
}
\value{
model, optimal sample size and detectable standardized effect sizes
}
\description{
Sample size in randomized complete block design is computed in order to detect a certain standardized effect size "delta" with power "1-beta" at the significance level "alpha".
}
\examples{
#only main effects
A<-Size.Block(factor=2, factor.lev=c(2,2),order=1,
delta_type=1, delta=c(1,0,1), alpha=0.05, beta=0.2)
A$model
A$n
A$Delta

#including two-way interaction effects
B<-Size.Block(factor=2, factor.lev=c(2,2),order=2,
delta_type=1, delta=c(1,1,1), alpha=0.05, beta=0.2)

}
\references{
Lenth,R.V., 2006-9. Java Applets for Power and Sample Size[Computer software]. Retrieved March 27, 2018 from http://www.stat.uiowa.edu/~rlenth/Power

Lim, Yong Bin, 1998. Study on the Size of Minimal Standardized Detectable Difference in Balanced Design of Experiments, \emph{Journal of the Korean society for Quality Management}, 26(4),239-249.

Marvin, A., Kastenbaum, A. and Hoel, D.G., 1970. Sample size requirements : one-way analysis of variance, \emph{Biometrika} 57(2),421-430.
}
