% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_forecast.R
\name{predict}
\alias{predict}
\title{Forecasting conditional volatilities with BEKK models}
\usage{
predict(x, n.ahead = 1, ci = 0.95)
}
\arguments{
\item{x}{A fitted bekk model of class bekk from the \link{bekk_fit} function}

\item{n.ahead}{Number of periods to forecast conditional volatility. Default is a one-period ahead forecast.}

\item{ci}{Floating point in [0,1] defining the niveau for confidence bands of the conditional volatility forecast. Default is 95 per cent niveau confidence bands.}
}
\value{
Returns a S3 class "bekkForecast" object containing the conditional volatility forecasts and respective confindence bands.
}
\description{
Method for predicting a N-dimensional BEKK covariances.
}
\examples{
\donttest{#'
data(StocksBonds)
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

x2 <- predict(x1, n.ahead = 1)

}

}
