% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utils.R
\name{readERF}
\alias{readERF}
\title{Read Ecotopes References File}
\usage{
readERF(filename, extra = NULL)
}
\arguments{
\item{filename}{name of the ecotopes reference file (character)}

\item{extra}{additional user-defined indices to be checked (\code{character}, see details)}
}
\description{
This function reads and checks files with reference values
}
\details{
The function performs the following tasks:
	\itemize{
		\item{checks the existence of \code{filename};}
 	\item{checks availablitity of required columns (case insensitive);}
 	\item{removes redundant spaces}
 	\item{removes duplicated records}
 }

 Argument \code{extra} is a \code{character} vector of additional benthic
 indices to be checked for. For example, if \code{extra = "ITI"}, then
 the ecotope reference file should also contain columns ITIREF and ITIBAD.

 The format of the ecotopes reference file is documented in the
 BEQI2-package vignette.
}
\references{
Van Loon, W, 2013. Loon2013-BEQI2-Specs-Ecotopes-27nov.doc
}

